package ThematicModelProto;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThematicModelBuilder{
	
	public ArrayList<Theme> themes = new ArrayList<Theme>();
	public ArrayList<Motif> motifs = new ArrayList<Motif>();
	public ArrayList<Natom> natoms = new ArrayList<Natom>();
	private Integer noise = 1;

	
	public static void main(String args[]){
		String outputFile = "results.xml";
		Integer noise = 1;
		String themesFolder = ThematicModelBuilder.class.getProtectionDomain().getCodeSource().getLocation().getPath();
		themesFolder = themesFolder.replace("tmb.jar", "")+"themes/";//because java is shit this returns something different if its in a jar file.
		boolean brief = false;
		//System.out.println(themesFolder);
		try {
			Integer selectionSize = new Integer(args[1]);
			
			ArrayList<String> themeNames = new ArrayList<String>(); 
			for(int i=2; i<args.length; i++){
				if(args[i].equals("-noise")){
					i++;
					noise = new Integer(args[i]);
				}else if(args[i].equals("-o")){
					i++;
					outputFile = args[i];
				}else if(args[i].equals("-t")){
					i++;
					themesFolder = args[i];
				}else if(args[i].equals("-brief")){
					brief = true;
				}else{
					themeNames.add(args[i]);
				}
			}
			
			
			ThematicModelBuilder tmb = new ThematicModelBuilder(themeNames, themesFolder, noise);
			tmb.loadFabula(args[0]);
			ArrayList<Natom> natoms = tmb.getStorySelection();
			String output = "";
			if(brief){
				output = tmb.selectionToBriefList(natoms, selectionSize);
			}else{
				Document natomsDOM = tmb.selectionToXML(natoms, selectionSize); 
				output = Helpers.xmlToString(natomsDOM);
			}
			
			if(outputFile.equals("-")){
				System.out.println(output);
			}else{
				try {
			        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
			        out.write(output);
			        out.close();
			    } catch (IOException e) {
			    	System.err.println(e);
			    }
			}
			
		    if(noise>1){
		    	System.err.println("...Record successfully written.");
		    }
		}catch(Exception e){
			System.err.println(ThematicModelBuilder.getHelp());
		}
		
		
	}
	
	
	public ThematicModelBuilder(ArrayList<String> themes, String foldername, int noise){
		this.noise = noise;
		
		if(noise > 1){
			System.err.println("New Thematic Mode Builder started");
		}
		
		for(String themeName:themes){
			Theme theme = new Theme(themeName, foldername);
			this.themes.add(theme);
			theme.getAllMotifs(this.motifs);
		}
		
	}
	
	public ThematicModelBuilder(ArrayList<String> themes,String foldername){
		this(themes, foldername, 1);
	}
	
	public void loadFabula(String fabulaFile){
		if(noise > 1){
			System.err.println("Loading Fabula from: "+fabulaFile+" ...");
		}

		Document doc = Helpers.parseXmlFile(fabulaFile);
		
		NodeList natomElements = doc.getElementsByTagName("natom");
		
		for(int i = 0; i<natomElements.getLength(); i++){
			NodeList natomChildren = natomElements.item(i).getChildNodes();
			String id ="";
			String url ="";
			String author="";
			HashSet<String> tags = new HashSet<String>();
			for(int k = 0; k<natomChildren.getLength(); k++){
				Node nn = natomChildren.item(k);
				String nname = nn.getNodeName();
				String value = nn.getTextContent();
				if(nname.equals("id")){ id=value; }
				if(nname.equals("url")){ url=value; }
				if(nname.equals("author")){ author=value; }
				if(nname.equals("tags")){
					NodeList tnl = nn.getChildNodes();
					for(int t = 0; t<tnl.getLength(); t++){
						Node tn = tnl.item(t);
						if(tn.getNodeName().equals("tag"))
							tags.add(tn.getTextContent());
					}
				}
			}
			natoms.add(new Natom(id, url, tags, author));
		
		}
		
		if(noise > 1){
			System.err.println("... Loaded Fabula");
		}
		
	}
	
	public HashMap<String, Integer> compileMotifListfoo(Theme theme){
		
		HashMap<String, Integer> compiledList = new HashMap<String, Integer>();

		if(noise > 3){
			System.err.println("Building motif list for "+theme.getName()+"...");
		}
		
		ArrayList<Motif> unpacked = new ArrayList<Motif>(); 
		theme.getAllMotifs(unpacked);
		
		for(int i =0; i<unpacked.size(); i++){
			
			if(compiledList.containsKey(unpacked.get(i).getName())){
				compiledList.put(unpacked.get(i).getName(), new Integer(compiledList.get(unpacked.get(i).getName()).intValue()+1));
			}
			else{
				compiledList.put(unpacked.get(i).getName(), new Integer(1));			
			}
		}
				
		return compiledList;
			
	}

	public double calculateComponentCoverage(ArrayList<Theme> themes, Natom natom){
		double componentsCovered = 0;
		ArrayList<Motif> motifs = new ArrayList<Motif>();
		ArrayList<Theme> subthemes = new ArrayList<Theme>();
		
		for(Theme theme: themes){
			motifs.addAll(theme.getChildMotifs());
			subthemes.addAll(theme.getChildThemes());
		}
		
		for(Motif motif: motifs){
			for(String tag: natom.getFeatures()){
				if(motif.getFeatures().contains(tag)){
					componentsCovered++;
				}
			}
		}
		componentsCovered += calculateThematicCoverage(subthemes, natom)*subthemes.size();
		
		return componentsCovered/(motifs.size()+subthemes.size());
	}

	public boolean motifsAreCovered(ArrayList<Motif> motifs, Natom natom){
		HashSet<String> features = new HashSet<String>();
		for(Motif motif:motifs){
			features.addAll(motif.getFeatures());
		}
		for(String tag:natom.getFeatures()){
			if(features.contains(tag)){
				return true;
			}
		}
		return false;
	}
	
	public double calculateThematicCoverage(ArrayList<Theme> themes, Natom natom){
		double themesMatched = 0;
		for(Theme theme: themes){
			ArrayList<Motif> motifs = new ArrayList<Motif>();
			theme.getAllMotifs(motifs);
			if(motifsAreCovered(motifs, natom)){
				themesMatched++;
			}
		}
		return themesMatched/themes.size();
	}

	public ArrayList<Natom> getStorySelection() {
		
		for(Natom natom:this.natoms){

			natom.thematicScore=calculateThematicCoverage(this.themes, natom);
			
			natom.componentScore=calculateComponentCoverage(this.themes, natom);
			
			natom.score = new Double((natom.thematicScore/2)+(natom.componentScore/2));

		}
		
		Collections.sort(this.natoms);
		
		return this.natoms;
		
	}
	

	
	
	public Document selectionToXML(ArrayList<Natom> natoms, int size){
		
		Document doc = Helpers.db.newDocument();
		
		System.out.println("Writing record xml...");

		//output+="<evallib name='"+name+"'> \n";
		
		//TODO may add this stuff back in but im not currently convinced its necessary and it makes the method header ugly
		/*output+="\t<collection fabula='"+fkeyword+"' fabulasize='"+fsize+"' colsize='"+size+"'> \n";
		output+="\t\t<themes> \n";
		for(int i =0; i<themes.size(); i++){
			output+="\t\t\t<theme>"+themes.get(i).getName()+"</theme> \n";			
		}
		output+="\t\t</themes> \n";
		*/

		Element natomsDOM = doc.createElement("natoms");
		doc.appendChild(natomsDOM);
		for(int i = 0; i<size; i++){
			natomsDOM.appendChild(natoms.get(i).toXML(doc));
		}

		return doc;
		//System.out.println("Writing xml to file D:\\PhD\\Thematics\\evaluation\\Evaluation2\\Records\\"+name+".rec ...");
	}

	public String selectionToBriefList(ArrayList<Natom> natoms, int size){
		String list = "";
		for(int i = 0; i<size; i++){
			list += natoms.get(i).getURL()+"\n";
		}
		return list;
	}
	
	public static String getHelp() {
		String help = "Thematic Model Builder Usage:\n";
		help += "\t tmb <fabula_file> <selection_size> <theme> [theme, theme, ...] [-o output_file] [-t theme_directory] [-noise int]";
		return help;
	}
	
	
}
/*
public ArrayList<Motif> stripList(ArrayList<Motif> al){
	
	ArrayList<Motif> res = new ArrayList<Motif>();
	
	for(int i = 0; i<al.size(); i++){
		
		if(!res.contains(al.get(i)))
			res.add(al.get(i));
		
	}
	
	return res;
	
}
*/
/*
public double calculateThematicFocus(Theme theme, Natom n){
	double res =0;
	
	float count = 0;
	
	complete=new ArrayList();
	ArrayList<Motif> motifs = new ArrayList<Motif>(); 
	motifs = theme.getMotifs(motifs);
	motifs = stripList(motifs);
	
	for(int i=0; i<n.features.size(); i++){
			boolean f = false;
			for(int k=0; k<motifs.size(); k++){
				if(this.motifs.get(motifs.get(k).getName().toLowerCase())!=null)
					if(motifs.get(k).getFeatures().contains(n.features.get(i).toLowerCase())){
						f=true;
					}
					
			}
			if(f)
				count++;
	}
	
	res=count/n.features.size()*100;
	
	double rounding = Math.ceil(res*100);
	res=rounding/100;
	
	return res;
}


public double calculateThematicMatch(Theme t, Natom n){
	double res =0;
	
	float count = 0;
	
	complete = new ArrayList();
	ArrayList<Motif> motifs = new ArrayList<Motif>(); 
	motifs = t.getMotifs(motifs);
	motifs = stripList(motifs);
	
	for(int k=0; k<motifs.size(); k++){
		boolean m = false;
		for(int i=0; i<n.features.size(); i++){
			if(this.motifs.get(motifs.get(k).getName())!=null)
					if(motifs.get(k).getFeatures().contains(n.features.get(i).toLowerCase())){
						m=true;
					}
		}
		if(m){
			count++;
		}
	}
	
	res=count/motifs.size()*100;
	
	double rounding = Math.ceil(res*100);
	res=rounding/100;
	
	return res;
}
*/

/*
public double calculateComponentFocus(Object c, Natom n){
	double res = 0;
	
	if(c instanceof Theme){
		res = calculateThematicFocus((Theme)c, n);
	}
	else if(c instanceof Motif ){
		res = calculateFocus(n, (Motif)c);
	}
	
	return res;		
}

public double calculateComponentMatch(Object c, Natom n){
	double res = 0;
	
	if(c instanceof Theme){
		res = calculateThematicMatch((Theme)c, n);
	}
	else if(c instanceof Motif){
		res = calculateMatch(n, (Motif)c);
	}
	
	return res;		
}
*/

/*	
	public double calculateFocus(Natom n, Motif m){
		double res = 0;
		float count = 0;
				
		for(int i=0; i<n.features.size(); i++){
				for(int k=0; k<m.getFeatures().size(); k++){
					if(n.features.get(i).equals(m.getFeatures().get(k))){
						count++;
					}
				}			
		}
		
		res=count/n.features.size()*100;
		
		double rounding = Math.ceil(res*100);
		res=rounding/100;
		
		return res;
	}
	
	
	public double calculateMatch(Natom n, Motif m){
		double res = 0;
		float count = 0;
				
		for(int i=0; i<n.features.size(); i++){
				for(int k=0; k<m.getFeatures().size(); k++){
					if(n.features.get(i).equals(m.getFeatures().get(k))){
						count++;
					}
				}			
		}
		
		res=count/m.getFeatures().size()*100;
		
		double rounding = Math.ceil(res*100);
		res=rounding/100;
		
		return res;
	}
	*/
/*
public ArrayList<Natom> getStorySelection(String fkeyword, int fsize, int size, boolean sameAuthorMultiple) throws IOException, SAXException, FlickrException{
	ArrayList<Theme> rthemes = new ArrayList<Theme>(this.themes.values());
	
	//fkeyword = fkeyword.toLowerCase();
	
	ArrayList<Natom> res = new ArrayList<Natom>();
	

	HashMap<Natom, Double> scores = new HashMap<Natom, Double>();
	HashMap<Double, ArrayList> results = new HashMap<Double, ArrayList>();

	ArrayList<Motif> motifList = new ArrayList<Motif>();
	motifList.addAll(this.motifs.values());

//LOAD THE FABULA - TODO make generate fabula seperate
	//TODO - Get rid of hard coded location
	String fabulaFile = "/home/patrick/cahphd/Thematics/implementation/fabula/"+fkeyword.replaceAll(" ", "")+fsize+".fab";
	File tf = new File(fabulaFile);
	if(!tf.exists()){	
		generateFabula(fkeyword, fsize);
	}
	else{
		loadFabula(fabulaFile);
	}
//END LOAD FABULA
	
	Iterator<String> ni = natoms.keySet().iterator();
	
	int debuglength = 0;
	
	while(ni.hasNext()){
		String n = ni.next();
		//scores.put(natoms.get(n), new Integer(calculateCoverage(motifslist, natoms.get(n))));
		natoms.get(n).thematicScore=calculateThematicCoverage(rthemes, natoms.get(n));
		double t = natoms.get(n).thematicScore;
		natoms.get(n).motifScore=calculateCoverage(motifList, natoms.get(n));
		t = natoms.get(n).motifScore;
		natoms.get(n).componentScore=calculateComponentCoverage(rthemes, natoms.get(n));
		
		Double score = new Double((natoms.get(n).thematicScore/2)+(natoms.get(n).componentScore/2));
	}
	
	
//DEDUPPING author - this should happen at fabula composition time		
		//Ensure that selection doesnt contain more then 1 natom by any one author.
		if(!sameAuthorMultiple){
			boolean replace = false;
			Natom replaceTarget = null;
			boolean firstItem = true;
			for(Natom na:scores.keySet()){
				String tempauthor = na.author;
				if(tempauthor.equals(natoms.get(n).author)){
					firstItem = false;
					if(score>scores.get(na)){
						//scores.remove(na);
						//scores.put(natoms.get(n), score);
						replace = true;
						replaceTarget = na;
					}
				}
			}
			
			if(firstItem)
				scores.put(natoms.get(n), score);
			if(replace){
				scores.remove(replaceTarget);
				scores.put(natoms.get(n), score);
			}
//END DEDUPPING
		}
		else{
			//scores.put(natoms.get(n), new Double((natoms.get(n).thematicScore/2)+(natoms.get(n).motifScore/2)));
			scores.put(natoms.get(n), score);
		}
			
		Iterator<Motif> mi = motifList.iterator();
		while(mi.hasNext()){
			String m = mi.next().getName();
			double[] focusmatch = new double[2];
			focusmatch[0]= calculateFocus(natoms.get(n), motifs.get(m));
			focusmatch[1]= calculateMatch(natoms.get(n), motifs.get(m));
			natoms.get(n).motifsmatch.put(m, focusmatch);
		}
		
		for(int i = 0; i<rthemes.size(); i++){
			
			double[] tfocusmatch = new double[2];
			tfocusmatch[0]= calculateThematicFocus(rthemes.get(i),natoms.get(n));
			tfocusmatch[1]= calculateThematicMatch(rthemes.get(i),natoms.get(n));
			natoms.get(n).themesmatch.put(rthemes.get(i).getName(), tfocusmatch);		
			
			for(int k = 0; k<rthemes.get(i).getRequired().size(); k++){
				
				Object comp;
				String cname;
				
				if(motifs.containsKey(rthemes.get(i).getRequired().get(k))){
					comp = motifs.get(rthemes.get(i).getRequired().get(k));
					cname = ((Motif)comp).getName();
				}
				else{
					comp = themes.get(rthemes.get(i).getRequired().get(k));
					cname = ((Theme)comp).getName();
				}
				
				double[] cfocusmatch = new double[2];
				cfocusmatch[0]= calculateComponentFocus(comp,natoms.get(n));
				cfocusmatch[1]= calculateComponentMatch(comp,natoms.get(n));
				natoms.get(n).componentsmatch.put(cname, cfocusmatch);					
			}
			
		}
		
		//natoms.get(n).thematicScore=scores.get(natoms.get(n));
		debuglength++;			
		
	}
	
	///////
	double topScore = 0;
	Double[] scoresar = new Double[scores.values().toArray().length];
	for(int r = 0; r<scores.values().toArray().length;r++){
		scoresar[r] = new Double(scores.values().toArray()[r].toString());
	}
	Arrays.sort(scoresar);
	ArrayList<Double> scoresal = new ArrayList();
	topScore=scoresar[scoresar.length-1];
	for(int k = scoresar.length-1; k>-1; k--){
		if(!scoresal.contains(scoresar[k]))
			scoresal.add(scoresar[k]);
	}
	
	Iterator<Natom> it = scores.keySet().iterator();
	while(it.hasNext()){
		Natom tn = it.next();
		if(results.containsKey(scores.get(tn))){
			ArrayList<Natom> temp = results.get(scores.get(tn));
			temp.add(tn);
			results.put(scores.get(tn), temp);
		}
		else{
			ArrayList<Natom> nal = new ArrayList();
			nal.add(tn);
			results.put(scores.get(tn), nal);
		}
	}
	
	for(int f = 0; f<scoresal.size(); f++){
		if(results.get(scoresal.get(f)).size()+res.size()<=size){
			System.out.println(results.get(scoresal.get(f)).size()+" "+res.size()+" - "+size);
			System.out.println("Adding "+results.get(scoresal.get(f)).size()+" natoms with score "+scoresal.get(f));
			res.addAll(results.get(scoresal.get(f)));				
		}
		else if(res.size()<size){
			System.out.println(results.get(scoresal.get(f)).size()+" "+res.size()+" - "+size);
			System.out.println("adding "+(size-res.size())+" natoms with score "+scoresal.get(f));
			int addlimit = size-res.size();
			for(int n = 0; n<addlimit; n++){
				res.add((Natom)results.get(scoresal.get(f)).get(n));
			}
			
		}		
	}
	
	System.out.println("natoms length: "+natoms.size());
	System.out.println("scores calculated: "+debuglength);
	
	return res;

}
	*/